--     Triggers.Talk:
-- timer,first_timer -     
-- amount - -   
-- duration -      
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
-- class 
GameObject = {
--  
    Params = {
        ID="telephon";
        image="telephon4";
        width=1;
        height=1;
        GridData = { 
            1
        };
        RandomTasks=0;
    };
    ActivePoints = { 
        talk = { 
                   { {}, 1,1,0,  0,  1,1,0 };
                   }; 
    };
    Objects = {};
    --     
    Tasks = {
        talk = { FuncName="TalkTaskExecute",  skill_up = 0, not_need_action=1 };   
        stop_ring = { FuncName="StopRingTaskExecute",  skill_up = 0, not_need_action=1 };   
        lift_handset = { FuncName="LiftHandsetExecute",  time_tick=20, timer=1, not_need_action=1 };   
        sleep_end = { FuncName="StopOnEndTaskExecute", hand_add=1 };
    };
    --     
    Triggers = {
        Talk = {FuncName="TalkTriger", NotRunWhen={"talk"}, timer={ 38 }, first_timer={ 55 }, amount=2, duration=15, cur_value=0 }
    };
    --      
    InitActiveTasks = {};
    --      
    InitExpectedTasks = {};
};
function GameObject:Get()
    return self;
end


--        
function OnInit()
--    
aInitObject = GameObject:Get();
aInitObject.Triggers.Talk.under_task = 0;
end




function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

function LiftHandsetExecute()
    CPP_StopSound("telephone_ring");
    CPP_SetAnimState("normal");
end

function TalkTaskExecute()
    aObj = GameObject:Get();   
    aObject.Triggers.Talk.under_task = 0;
    aObject.Triggers.Talk.amount = aObject.Triggers.Talk.amount - 1;
    --      
    CPP_RecursiveRun("telephone_order",0);
    return 0;
end

function StopRingTaskExecute()
    aObj = GameObject:Get();   
    aObject.Triggers.Talk.under_task = 0;
    aObject.Triggers.Talk.amount = aObject.Triggers.Talk.amount - 1;
    CPP_StopSound("telephone_ring");
    CPP_SetAnimState("normal");
    return 0;
end

function TalkTriger()
    aObject = GameObject:Get();
    
    local aTrigger = aObject.Triggers.Talk;
    --         
    if (aTrigger.amount <= 0) then return; end
    --      
    if (aTrigger.under_task == 1) then 
        if (aTrigger.no_run_stop == 1) then return; end
        aTrigger.cur_duration = aTrigger.cur_duration + 1;
        if (aTrigger.cur_duration >= aTrigger.duration) then
            local res = CPP_DoTaskIfPossible("stop_ring","talk");
            if (res == 0) then
                aTrigger.no_run_stop = 1;
            else
                CPP_StopSound("telephone_ring");
                CPP_SetAnimState("normal");
                CPP_WantSelect(0);
            end
        end
        return; 
    end
    
    if ((not aTrigger.cur_value) or (aTrigger.cur_value == 0)) then
        aTrigger.cur_value = GetTriggerTimerRand(aTrigger);
        return;
    end
    
    aTrigger.cur_value = aTrigger.cur_value - 1;
    if (aTrigger.cur_value <= 0) then
        aTrigger.cur_value = 0;
        --      
        aTrigger.under_task = 1;
        aTrigger.cur_duration = 0;
        aTrigger.no_run_stop = 0;
        CPP_AddExpectedTasks("talk");
        CPP_WantSelect(1);
        CPP_PlaySound("telephone_ring",1);
        CPP_SetAnimState("ringing");
    end
end 

function StopOnEndTaskExecute()
    CPP_StopSound("telephone_ring");
    CPP_SetAnimState("normal");
    return 0;
end
